import { GetCouponRequest } from "../../src/shared/services/getCoupon";
import { getCoupon } from "../_stripe";

export const onRequestPost: PagesFunction<PagesEnv> = async ({
  request,
  env,
}) => {
  const coupon = (await request.json()) as GetCouponRequest;
  const response = await getCoupon(coupon.couponId, env.STRIPE_SECRET_KEY);
  return new Response(
    JSON.stringify({
      // @ts-ignore
      res: response,
    })
  );
};
