export interface CreateUserRequest {
  email: string;
  firstName: string;
  lastName: string;
  credentials: string;
  affiliateId: string | number | null;
}

interface CreateUserResponse {
  user: any;
}

export const createAppUser = async (
  user: CreateUserRequest
): Promise<CreateUserResponse> => {
  const request = await fetch("/api/create-app-user", {
    method: "POST",
    body: JSON.stringify(user),
    headers: {
      "Content-Type": "application/json",
    },
  });

  if (!request.ok) {
    const resp = (await request.json()) as any;
    throw new Error(resp?.error || `Failed to create user`);
  }

  return request.json();
};
