export interface GetCouponRequest {
  couponId: string;
}

interface CreateUserResponse {
  clientSecret: string;
  customerId: string;
}

export const getCoupon = async (coupon: GetCouponRequest): Promise<any> => {
  console.log(coupon, "coupon1");

  const request = await fetch("/api/get-coupon", {
    method: "POST",
    body: JSON.stringify(coupon),
    headers: {
      "Content-Type": "application/json",
    },
  });

  if (!request.ok) {
    const resp = (await request.json()) as any;
    throw new Error(resp?.error || `Coupon not existed`);
  }

  return request.json();
};
